    clear all;
    close all;

%File details
    delimiterIn = ',';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    figure;
    hold on;  
        
    n = 1;
    
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
   
%Plot Data
    i = 1;
while(Data(i,1)<6) 
    i = i + 1; 
end

p = polyfit(Data(1:i,1),Data(1:i,2),1);

x1 = linspace(0,16);
y1 = polyval(p,x1);

plot(x1,y1,'--r','HandleVisibility','off');
plot(Data(:,1),Data(:,2));
    
    
    end
    
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('T (K)','fontsize',20,'fontname','times');
    ylabel('R (\Omega)','fontsize',20,'fontname','times');
    set(findall(gca, 'Type', 'Line'),'LineWidth',1);
    title('FeSeLF9 R_{xy} component');
    box on;
    hold off;

